import { z } from "zod";

export const statusMetadataErrorSchema = z.object({
  message: z.string()
})

export const statusMetadataSchema = z.object({
  metadata: z.object({
    paths: z.object({
      files: z.string()
    })
  })
})

export const statusMetadataGetResponseSchema = z.union([
  statusMetadataErrorSchema,
  statusMetadataSchema,
])

export type AppStatusMetadataGetResponse = z.infer<typeof statusMetadataGetResponseSchema>
export type AppStatusMetadataError = z.infer<typeof statusMetadataErrorSchema>
export type AppStatusMetadata = z.infer<typeof statusMetadataSchema>
